﻿/* Copyright 2015 Intellica Corporation 
Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at
    http://www.apache.org/licenses/LICENSE-2.0
Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
*/
if (typeof (question) === "undefined") {
    var question = {};
}

question.mid4044 = {
    //general options and settings
    opts: {
        questions: {
            hideByDefault: function () {
                return $('div[id$="TID1_QID4"],div[id$="TID1_QID6"],div[id$="TID1_QID8"],div[id$="TID1_QID11"],div[id$="TID1_QID14"],div[id$="TID1_QID18"],div[id$="TID1_QID20"]');
            },
            _qTID1QID7: 'TID1_QID7',
            _qTID1QID8: 'TID1_QID8',
            _qTID1QID10: 'TID1_QID10',
            _qTID1QID11: 'TID1_QID11',
            _qTID1QID17: 'TID1_QID17',
            _qTID1QID18: 'TID1_QID18'
        }
    },

    //hide questions by default
    hideQuestions: function () {
        var _me = this;

        $.each(_me.opts.questions.hideByDefault(), function (i, _divQ) {

            //set 'skipped' attribute
            $(_divQ).attr('skipped', true);
            $('[name^="grp"]', $(_divQ)).each(function () {
                var _name = $(this).attr('name');
                if (_name.indexOf("skip_") < 0) {
                    $(this).attr("name", "skip_" + _name);
                }
            });

            //no need to reset question's responses as is the first time loading and there are no answers
            //_me.clearQuestionResponses(_divQ);

            //hide question
            $(_divQ).hide();

        });

    },

    clickAction: function (valQ, targetQ) {
        var _divValQ = $('div[id$="' + valQ + '"]'),
            _divQ = $('div[id$="' + targetQ + '"]');

        if ($('input[type="checkbox"]:checked', _divValQ).length > 0) {
            //show question
            if ($(_divQ).is(':hidden')) {
                //remove 'skipped' attribute
                $(_divQ).removeAttr('skipped');
                $('[name^="skip_"]', $(_divQ)).each(function () {
                    var _name = $(this).attr('name');
                    if (_name.indexOf("skip_") >= 0) {
                        $(this).attr("name", _name.replace(/skip_/gi, ''));
                    }
                });

                //reset question's responses
                if (!question.opts.isPreloaded) {
                    question.clearQuestionResponses(_divQ);
                }

                //show question
                _divQ.show();
            }
        }
        else {
            //hide question
            if ($(_divQ).is(':visible')) {
                //set 'skipped' attribute
                $(_divQ).attr('skipped', true);
                $('[name^="grp"]', $(_divQ)).each(function () {
                    var _name = $(this).attr('name');
                    if (_name.indexOf("skip_") < 0) {
                        $(this).attr("name", "skip_" + _name);
                    }
                });

                question.clearQuestionResponses(_divQ);

                //hide question
                _divQ.hide();
            }
        }
    },

    //bind responses click event
    bindResponseClick: function () {
        var _me = this,
            _divQTID1QID7 = $('div[id$="' + _me.opts.questions._qTID1QID7 + '"]'),
            _divQTID1QID10 = $('div[id$="' + _me.opts.questions._qTID1QID10 + '"]'),
            _divQTID1QID17 = $('div[id$="' + _me.opts.questions._qTID1QID17 + '"]');

        $('input[type="checkbox"]', _divQTID1QID7).each(function (i, ele) {
            $(ele).unbind('click').bind({
                click: function (e) {
                    _me.clickAction(_me.opts.questions._qTID1QID7, _me.opts.questions._qTID1QID8);
                }
            });
        });

        $('input[type="checkbox"]', _divQTID1QID10).each(function (i, ele) {
            $(ele).unbind('click').bind({
                click: function (e) {
                    _me.clickAction(_me.opts.questions._qTID1QID10, _me.opts.questions._qTID1QID11);
                }
            });
        });

        $('input[type="checkbox"]', _divQTID1QID17).each(function (i, ele) {
            $(ele).unbind('click').bind({
                click: function (e) {
                    _me.clickAction(_me.opts.questions._qTID1QID17, _me.opts.questions._qTID1QID18);
                }
            });
        });

    },

    //initializing functions
    init: function (callback) {
        var _me = this;

        //wait for DOM readiness
        $(document).ready(function () {
            Ext.onReady(function () {
                setTimeout(function () {
                    //call functions here
                    //if (!question.opts.isPreloaded) {
                        _me.hideQuestions();
                    //}

                    _me.bindResponseClick();

                    //Successful
                    if (callback) {
                        if (typeof (callback.success) == "function") {
                            callback.success();
                        }
                    }
                }, 1);
            });
        });
    }
};